#ifndef GPSLIB_H

#include "dstring.h"

extern int verbose;	// set for verbose output, of course
extern const double deg2rad;
const double metres2miles = 6.213712e-04;

// Read n digits from a char *, move the pointer and return the int
int rdint(const char *&cpr, int ndigs);

// Logfile manipulation
int openlogfile(const char*cp, bool forwriting = false);
int closelogfile();
// write a newline-terminatd string to the logfile if open
void putlogfpstring(const char *cp);
int getscale(double*minlat, double*maxlat, double*minlong, double*maxlong);
int getlogstr(char*latp);
int getlogll(double &latit, double &longit, double &utctime);
int rcvplotstr(const String &plotstr, double &latit, double &longit, double &uctime);
int openlandmarkfile(const char*cp);
int closelandmarkfile();
int getlandmark(double*latp, double*longp, char*desp, int desplen, char*type, int tlen);
double getlatitude(const char*&cpr);
double getlongitude(const char*&cpr);

// Convert from fractional degrees to d/m/s
String deg_min_secs(double);
String dmsLat(double);
String dmsLong(double);

// NGR trig calculations
void capm(double lat1, double lat2, double*res);
int cvtongr(double latdeg, double longitdeg, String &res, double &eres, double
&nres);
int getngrfromdegs(double latdeg, double longitdeg, String &res);
void cvtngrlatlongdeg(double east, double north, double *lat, double *longit);
int cvtngrstr(const char*ngrstr, long*eastres, long*northres, double*latres, double*longres);

// convert ngr in its various forms and leave the pointer at the next char
int _cvtngrstr(const char*&ngrstr, long*eastres, long*northres, double*latres, double*longres);

// Map manipulation 
struct mapinfo{
	String name;
	double longmax, longmin, latmax, latmin;
	double eastmax, eastmin, northmax, northmin;
	long pixwidth, pixheight;
	double pixperdegwidth, pixperdegheight;
	double pixpermetrewidth, pixpermetreheight;
	double scalefamily;	// When matched, which approximate scale I'm from
	int osproj;		// uses OSGB projection
	void print()const;
};

int initmaplist(const char*mapname);
int enumeratemaps(double lat, double longit, char*namep, int*namelen, double*nscalep, double*escalep);
int locatemap(double lat, double longit, String &name, double &nscale, double &escale);
const mapinfo* locatemapinfo(double lat, double longit);

// Call enumeratescales if locatemap has returned true.
// Returns list of pixperdegreeN
void enumeratescales(list_of<double> &lodr);

// Request map scale - if nonzero, locatemap above finds best fit to scale
// then for maps +/- 20% find the one with the best center
void locatescale(double pixperdegn);

// Right then - show this map on the designated window whose centre is given
int showmap(const char*name, double midlat, double midlong, int hwnd);

// Used in error reporting - pops up a printf-style error message in
// a messagebox - returns 0 (always)
int printwhinge(const char *fmt ...);
#endif
