#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "dstring.h"
#include "genarray.h"
#include <stdarg.h>

#pragma intrinsic strcpy
#pragma intrinsic memset
#pragma intrinsic memcpy

const char *String::NULLCHARSTRING = "";
String String::NULLSTRING;

inline void String::String_data::operator++(){refcnt++;}
void String::String_data::operator--(){if(--refcnt == 0)delete this;}

String::String_data *String::newsdp(size_t nbytes){
	String::String_data *sp = (String::String_data*)new char[sizeof(int)+nbytes];
	sp->refcnt = 1;
        assert(sp);
	return sp;
}

String::String_data *String::newsdp(String::String_data *sdp){
	unsigned nbytes = strlen(sdp->data)+1;
	String::String_data *sp = newsdp(nbytes);
	memcpy(sp->data, sdp->data, nbytes);
	return sp;
}

unsigned String::hashval(const char *cp){
	unsigned res = 0;
        char c;
	while((c = *cp++) != 0)
		res += c;
        return res;
}

#ifdef STRING_POOL_ALLOC
// A special allocation pool for Strings (the String handle is small
// and is allocated a lot).
String * String::freelist = 0;
const int allocblocksize = 100;

void * String::operator new(size_t size){
	// First of all, check that we are allocating the right size of
	// object. This may not be true if we are allocating a derived
	// kind of object which is bigger, and the appropriate redefinition
	// of of operator new() has not been done for that class.
	// If the size is "wrong", then we let the standard operator handle it.
	// See also the comment in operator delete() for a similar concern
	if(size != sizeof(String))
		return ::operator new(size);

	// Is there no remaining space allocated?
	if(freelist == 0){
		// Grab a new chunk of allocblocksize elements
		freelist = (String *)new char[allocblocksize * sizeof(String)];
		if(freelist == 0)
			return 0;
		// Now make sure that they all form an appropriately-linked list
		for(int i = 0; i < allocblocksize-1; i++)
			freelist[i].freeptr = &freelist[i+1];
		freelist[i].freeptr = 0;
	}

	// Retrieve first item from the list and return it
	String *shp = freelist;
	freelist = freelist->freeptr;
	return shp;
}

void String::operator delete(void *vp, size_t size){
	// We do not have a cast-iron guarantee that the size is right,
	// since we may be deleting a derived class object through its
	// base class pointer and it's apparent size will be wrong.
	// On the other hand, if it has a virtual destructor, or the
	// delete is applied to a non-base pointer, the size WILL be right.
	// If we can tell that this was not really allocated from the pool,
	// hand it back to the global delete operator.
	if(size != sizeof(String)){
		::delete(vp);
		return;
	}
	// Well, it looks as if it is one of ours. Stitch it into the free
	// list. If it wasn't allocated the normal way and is bigger, this
	// means that we will lose some memory
	((String *)vp)->freeptr = freelist;
	freelist = (String *)vp;
}
#endif

// if our current data is shared with others, take a copy of it (it is
// about to be changed)
void String::single_copy(){
	if(sdp->refcnt == 1)
		return;
	String_data *nsdp = newsdp(sdp);
	--*sdp;
	sdp = nsdp;
}

// WARNING - init() must only be called by constructors (assumes cp unset)
void String::init(const char *ccp){
	if(ccp){
		size_t l = strlen(ccp)+1;
		sdp = newsdp(l);
		memcpy(sdp->data, ccp, l);
	}else{
		sdp = newsdp(1);
		sdp->data[0] = 0;
	}
}

String::String(){
	init("");
}

String::String(const char * s){
	init(s);
}

String::String(char c){
	static char car[2];
	car[0] = c;
	car[1] = 0;
	init(car);
}

// Create a substring
String::String(const char *ccp, size_t nbytes){
	size_t l = strlen(ccp);
	if(nbytes < l)
		l = nbytes;
	sdp = newsdp(l+1);
	memcpy(sdp->data, ccp, l);
	sdp->data[l] = 0;
}

/*
 * This is very awk-like!
 * Construct a String from an int - build the character representation
 * of the int first, then build a String!
 */
String::String(int i){
	char car[20];
	::sprintf(car,"%d", i);
	init(car);
}

String::String(unsigned u){
	char car[20];
	::sprintf(car,"%u", u);
	init(car);
}

String::String(long l){
	char car[20];
	::sprintf(car,"%ld", l);
	init(car);
}

String::String(unsigned long l){
	char car[20];
	::sprintf(car,"%lu", l);
	init(car);
}


String::String(const String& s){
	sdp = s.sdp;
	++*sdp;
}

String & String::operator =(const String & s){
	++*s.sdp;
	--*sdp;
	sdp = s.sdp;
        return *this;
}

String & String::operator = (const char *ccp){
	if(ccp == 0){
		printf("Panic: assigning null String\n");
		exit(-1);
	}
	size_t l = strlen(ccp)+1;
	String_data *nsdp = newsdp(l);
	memcpy(nsdp->data, ccp, l);
	--*sdp;
	sdp = nsdp;
        return *this;
}

String::~String(){
	--*sdp;
}

String operator +(const String &s1, const String &s2){
	size_t newlen, oldlen;
	oldlen = s1.nchars();
	size_t s2len = s2.nchars();
	newlen = oldlen + s2len;
	assert(newlen >= oldlen && newlen >= s2len);

	String::String_data *nsdp = String::newsdp(newlen+1);
	// strcpy(nsdp->data, s1.sdp->data);
	memcpy(nsdp->data, s1.sdp->data, oldlen);
	// strcpy(nsdp->data+oldlen, s2.sdp->data);
	memcpy(nsdp->data+oldlen, s2.sdp->data, s2len+1);
	// String reslt(nsdp);
	// --*reslt.sdp;
	// reslt.sdp = nsdp;
	// return reslt;
	return nsdp;		// Use special constructor
}

String operator +(const String &cs, const char *csp){
	return cs + String(csp);
}

String operator +(const String &cs, char c){
	return cs + String(c);
}

String operator +(char c, const String &cs){
	return String(c) + cs;
}

String operator +(const char *csp, const String &cs){
	return String(csp)+cs;
}

String & String::operator +=(char c){
	static char car[2];
	car[0] = c;
	car[1] = 0;

	return operator +=(car);
}

String & String::operator +=(const String& s){
	return operator = (*this+s);
}

String & String::operator +=(const char *csp){
	return operator = (*this+csp);
}

void String::operator ++(){
	String i(operator int() + 1);
	operator =(i);
}

String::operator int()const{
	return (int)strtol(sdp->data, 0, 0);
}

int operator ==(const String& s1, const String& s2){
	return(strcmp(s1.sdp->data, s2.sdp->data) == 0);
}

int operator ==(const String& s1, const char *s2){
	return(strcmp(s1.sdp->data, s2) == 0);
}

int operator	>(const String& cs1, const String& cs2){
	return strcmp(cs1.sdp->data, cs2.sdp->data) > 0;
}

int operator	>(const String& cs1, const char * cs2){
	return strcmp(cs1.sdp->data, cs2) > 0;
}

int operator	<(const String& cs1, const String& cs2){
	return strcmp(cs1.sdp->data, cs2.sdp->data) < 0;
}

int operator	<(const String& cs1, const char * cs2){
	return strcmp(cs1.sdp->data, cs2) < 0;
}

char String::operator [](size_t index1)const{

	if(index1 <= 0 || index1 > nchars()){
		return(0);
	}

	return(sdp->data[index1-1]);
}

String String::substr(size_t start, size_t len)const{

	const size_t nc = nchars();
	//printf("substring: start %lu, len %lu nc %lu\n", start, len, nc);

	if(start < 1 || start > nc){
		return("");
	}

	if(len < 1){
		return("");
	}
	/*
	 * len is allowed to be `too' long. Shorten if necessary
	 * Explanation of arithmetic: assume n bytes length (1..n)
	 * then start+allowable_length == n+1 (consider start==1, len == n).
	 * Clearly, allowable_length = n+1 - start
	 */
	// This first test should eliminate nasty problems caused by overflow.
	// The problem was caused by substr(6,-6);
	if(len > nc){
		len = nc;
	}
	if(start+len > nc+1)
		len = nc + 1 - start;
	//printf("substring: start %lu, len %lu nc %lu\n", start, len, nc);

	/* can't use strncpy - doesn't guarantee a null at the end */
	String_data *nsdp = newsdp(len+1);
	// char *ncp = new char [nc+1];
	memcpy(nsdp->data, sdp->data+start-1, len);
	nsdp->data[len] = 0;
	// String temp = ncp;
	// delete [] ncp;

	return(nsdp);
}

String String::left(size_t n)const{
	return substr(1, n);
}

String String::right(size_t n)const{
	const nc = nchars();
	int start = nc-n+1;
	if(start < 1)
        	start = 1;
        return substr(start, n);
}

// Could be more efficient, but this hack works for the present
String String::tailstr(size_t startpos1)const{
	return substr(startpos1, nchars());
}

// copy cp2 into cp - don't ovewrite the end or copy the null
void copystr(char *cp, const char *cp2){
	while(*cp)
		if(*cp2)
			*cp++ = *cp2++;
		else
			return;
}

// Set the designated character to the designated value
void String::set_char(size_t index1, char cval){
	if(index1 <= 0 || index1 > nchars())
		return;
	single_copy();
	sdp->data[index1-1] = cval;
}

// Set the subString at startpos with the contents of set_from.
// Make room at the end if necessary.
// The funny stuff with tmpstr is because we may be setting a subString
// of ourselves with ourself (this is like String assign, but nastier)
void String::set_substr(size_t startpos, const char * set_from, char filler){
	const size_t oldlen = nchars();

	if(startpos < 1){
		return;
	}

	const int from_length = strlen(set_from);

	// create a String with a guaranteed reference count of 1
	String tmpstr(*this);
	tmpstr.single_copy();

	// Is there room? If not, pad.
	// Why -1? Imagine a String length 1, set position 1 to 'a';
	// don't want it to be 2 bytes long, do we?
	if(startpos+from_length-1 > oldlen)
		tmpstr.pad_to_length(startpos+from_length-1, filler);

	// and set - can't use strcpy, don't want the null at the end
	char *cp1 = tmpstr.sdp->data+startpos-1;
	copystr(cp1, set_from);

	// and swap our sdp with tmpstr - the delete is done when tmpstr
	// is zapped
	String_data *tmpsdp = sdp;
	sdp = tmpstr.sdp;
	tmpstr.sdp = tmpsdp;

}

// Pad the String to length with the designated character
// This used to be coded for compactness - the new version is for speed
/*
void String::pad_to_length(size_t length, char filler){
	const size_t oldlen = nchars();
	const size_t lendiff = length-oldlen;
	if(oldlen < length){
		char *ncp = new char[lendiff+1];
		memset(ncp, filler, lendiff);
		ncp[lendiff] = 0;
		operator +=(ncp);
		delete [] ncp;
	}
}
*/
void String::pad_to_length(size_t length, char filler){
	const size_t oldlen = nchars();
	const size_t lendiff = length-oldlen;
	if(oldlen < length){
		String_data *nsdp = newsdp(length+1);
		memcpy(nsdp->data, sdp->data, length+1);
		--*sdp;
		sdp = nsdp;
		memset(nsdp->data+oldlen, filler, lendiff);
		nsdp->data[length] = 0;
	}
}

void String::cvt_toupper(){
	// assume that it will make a change, but don't copy own data
	// unnecessarily ...
	single_copy();
	char c;
	for(char *ccp = sdp->data; (c = *ccp) != 0; ccp++){
		if(isascii(c) && islower(c))
			*ccp = toupper(c);
	}
}

void String::cvt_tolower(){
	// assume that it will make a change, but don't copy own data
	// unnecessarily ...
	single_copy();
	char c;
	for(char *ccp = sdp->data; (c = *ccp) != 0; ccp++){
		if(isascii(c) && isupper(c))
			*ccp = tolower(c);
	}
}

unsigned long String::ulongval()const{
	return ulongval(10);
}

unsigned long String::ulongval(int base)const{
	char *cp = 0;
        return strtoul(sdp->data, &cp, base);
}
double String::doubleval()const{
	return strtod(sdp->data, 0);
}

void String::sprintf(const char *fmt, ...){
	// char *msgbuf = new char[512];
	// if(msgbuf == 0)
	// 	return;
	char msgbuf[512];
        //msgbuf[511] = 0xff;

	va_list vl;
	va_start(vl, fmt);
	vsprintf(msgbuf, fmt, vl);
	va_end(vl);
	//if(msgbuf[511] != (char)0xff){
	//	const char *cp = "Aaargh - sprintf overflow\n";
	//}

        // Yes, this could be made more efficient, but I prefer small code!
	operator =(msgbuf);
	// delete [] msgbuf;
}

// Case-insensitive comparisons. Return true for equal, false otherwise
int caseicmp(const char *cp1, const char *cp2){
	for(;;){
		char c1 = *cp1++, c2 = *cp2++;
		if(c1 == c2){
			if(c1 == 0)
				return 1;
			else
				continue;
		}
		// Not equal
		if(tolower(c1) == tolower(c2))
			continue;
                return 0;
        }
}

int caseicmp(const char *cp1, const String &sr){
	return caseicmp(cp1, sr.cstring());
}
int caseicmp(const String &sr1, const String &sr2){
	return caseicmp(sr1.cstring(), sr2.cstring());
}
int caseicmp(const String &sr, const char *cp){
	return caseicmp(sr.cstring(), cp);
}


array_of_String::array_of_String(){
}

//array_of_String::array_of_String(const array_of_String& csr){
//	// implementation = new generic_ptr_array;
//	for(int i = 0; i < csr.element_count(); i++)
//		operator +=(csr[i]);
//}

//array_of_String::~array_of_String(){
//	// empty();
	// delete (generic_ptr_array *)implementation;
//}

// void array_of_String::delete_last_element(){
// 	generic_ptr_array *gp = (generic_ptr_array *)implementation;
// 	delete (String *)(gp->last());
// 	gp->delete_last_element();
// }

// int array_of_String::element_count()const{
// 	return ((generic_ptr_array *)implementation)->element_count();
// }

// void array_of_String::insert_before_element(int index, const String &r){
// 	generic_ptr_array *gp = (generic_ptr_array *)implementation;
// 	gp->insert_before_element(index, new String(r));
// }

// void array_of_String::operator+=(const String &r){
// 	generic_ptr_array *gp = (generic_ptr_array *)implementation;
// 	gp->operator +=(new String(r));
// }

// void array_of_String::push(const String &r){
// 	generic_ptr_array *gp = (generic_ptr_array *)implementation;
// 	gp->push(new String(r));
// }

// String array_of_String::last_element()const{
// 	generic_ptr_array *gp = (generic_ptr_array *)implementation;
// 	return *(String *)(gp->last());
// }

// String array_of_String::pop(){
// 	generic_ptr_array *gp = (generic_ptr_array *)implementation;
// 	String *sp = (String *)(gp->pop());
// 	String rv = *sp;
// 	delete sp;
// 	return rv;
// }

// void array_of_String::delete_this_element(int index){
// 	generic_ptr_array *gp = (generic_ptr_array *)implementation;
// 	delete (String *)(gp->operator[](index));
// 	gp->delete_this_element(index);
// }

String & array_of_String::operator [](int i){
// 	generic_ptr_array *gp = (generic_ptr_array *)implementation;
// 	String *s = (String *)(gp->operator[](i));
// 	if(s)
//	 	return *s;
	if(i >= 0 && i < element_count())
		return list_of<String>::operator[](i);
	static String oops;
	oops = "";
	return oops;
}

String array_of_String::extract(){
	String rval = operator[](0);
	delete_this_element(0);
	return rval;
}

const String& array_of_String::operator[](int i)const{
	return ((array_of_String *)this)->operator[](i);
}

// Take the String and break it into fields, appending them to the designated
// array. The fields are separated by characters in the "delims" argument,
// else whitespace. This is used extensively in the uucp code and seems to
// work, but the logic of everything to do with delimiter checking has not
// been formally tested on anything other than whitespace. Improvements would
// perhaps be to allow a flag to specify whether consecutive delimiters indicate
// empty fields or not... now done, see "strict"

static int getargs(const String&csr, array_of_String &sar, const char *delims, int strict);
static int getargs(const String &csr, array_of_String &sar);

// Take a line of text. Split it into fields, where white space is the
// separator
int getargs(const String &csr, array_of_String &sar){
	return getargs(csr, sar, " \t\n", 0);
}

int array_of_String::getfields(const String &csr){
	return ::getargs(csr, *this);
}

int array_of_String::getfields(const String &csr, const char *delims){
	return ::getargs(csr, *this, delims, 0);
}

int array_of_String::strictgetfields(const String &csr, const char *delims){
	return ::getargs(csr, *this, delims, 1);
}

// Strict means that *each* delimiter indicates a field
int getargs(const String&csr, array_of_String &sar, const char *delims, int strict) {
	const char *line = csr.cstring();
	int i = 0;
	sar.clear();

	while (*line != '\0') {
		// skip leading delimiters ...
		if (strchr(delims, *line)){
			if(strict)
                        	sar += "";
			line++;
		}else {
			// got a non-delim character; record it
			String thisfield = line;
			const char *start = line;
			i++;
                        char cdelim;
			while((cdelim = *line) != 0 && !strchr(delims, cdelim) )
				line++;
			// at just off end now
			thisfield = thisfield.substr(1, int(line-start));
			sar += thisfield;

			// And move past the delimiter
			if(cdelim)
				line++;

		}
	}

	return i;
}

int array_of_String::findat(const char * csr, findcase f){
	return findat(String(csr), f);
}
int array_of_String::findat(const String &csr, findcase f){
	String search = csr;
	if(f == ignorecase){
		search.cvt_tolower();
	}
	for(int i = 0; i < element_count(); i++){
		String cmp = operator[](i);
		if(f == ignorecase){
			cmp.cvt_tolower();
		}
		if(search == cmp)
			return i;
	}
	return -1;
}
/*
void array_of_String::operator =(const array_of_String &rhs){
	if(this == &rhs)
		return;
	clear();
	for(int i = 0; i < rhs.element_count(); i++){
		*this += rhs[i];
	}
}
*/

/*
void array_of_String::sort(direction d){
	// generic_ptr_array *gp = (generic_ptr_array *)implementation;
	list_of<String> &lor = *this;
	// A simple bubble sort is used - anything else is unlikely
	// to be a lot better
	const int upperbound = lor.element_count();
	for(int i = 0; i < upperbound-1; i++){
		for(int j = i+1; j < upperbound; j++){
			void *&v1 = (lor.element_ref(i));
			void *&v2 = (lor.element_ref(j));
			if((*(String*)v1 > *(String *)v2) == (d == up)){
				// swap them
				void *tv = v1;
				v1 = v2;
				v2 = tv;
			}
		}
	}
}
*/

#ifdef MAIN
#include <iostream.h>
main(){
	String s = "hello";
	cout << s.cstring() << '\n';

	s.pad_to_length(15, '*');
	cout << s.cstring() << '\n';

	s.set_substr(5, "12345");
	cout << s.cstring() << '\n';

	s.set_substr(10, "abcdefghijklm");
	cout << s.cstring() << '\n';

	s = "";
	cout << "nchars " << s.nchars() << '\n';
	//s.pad_to_length(10);
	//cout << "nchars " << s.nchars() << '\n';

	s.set_substr(10, "abcdefghijklm");
	cout << "nchars " << s.nchars() << '\n';
	cout << s.cstring() << '\n';

	cout << "now toupper and back\n";
	s.cvt_toupper();
	cout << s.cstring() << '\n';
	s.cvt_tolower();
	cout << s.cstring() << '\n';

	cout << "\nNow trying to sort an array\n";
	array_of_String sar;
	sar += "xyz";
	sar += "1234";
	sar += "abc";
	sar += "foo";
	sar.sort();
	for(int i = 0; i < sar.element_count(); i++)
		cout << sar[i].cstring() << '\n';
	cout << "Done\n";
}
#endif
